function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 108);

T = NK_financial.dynamic_g1_tt(T, y, x, params, steady_state, it_);

T(101) = getPowerDeriv(T(7),1-params(6),2);
T(102) = T(50)*T(101);
T(103) = (-((-(T(48)*y(76)))*(y(29)+y(29))))/(y(29)*y(29)*y(29)*y(29));
T(104) = (-T(48))/(y(29)*y(29));
T(105) = getPowerDeriv(y(81),params(5),2);
T(106) = getPowerDeriv(T(22),1-params(5),2);
T(107) = getPowerDeriv(y(40)*y(46),params(2),2);
T(108) = getPowerDeriv(T(37),1-params(4),2);

end
